<?php
require_once 'config.php';

/* ambil parameter filter */
$employee_id = $_GET['employee_id'] ?? null;
$month       = $_GET['month'] ?? null;
$search      = $_GET['search'] ?? null;

/* query utama */
$sql = "SELECT 
        e.name AS employee,
        t.name AS team,
        am.activity_name,
        am.sub_activity_name,
        am.target_volume,
        IFNULL(SUM(de.volume_today),0) AS realisasi,
        CASE 
          WHEN am.target_volume IS NOT NULL AND am.target_volume>0
          THEN ROUND(IFNULL(SUM(de.volume_today),0)/am.target_volume*100,0)
          ELSE 0 
        END AS capaian,
        DATE_FORMAT(am.deadline,'%Y-%m-%d') AS deadline
        FROM activity_master am
        JOIN employees e ON e.id=am.employee_id
        JOIN teams t ON t.id=am.team_id
        LEFT JOIN daily_entries de ON de.activity_master_id=am.id
        WHERE 1 ";

$params = [];
$types  = "";

/* filter pegawai */
if($employee_id){
    $sql .= " AND am.employee_id=? ";
    $types .= "i";
    $params[] = (int)$employee_id;
}

/* filter bulan */
if($month){
    $sql .= " AND am.month=? ";
    $types .= "i";
    $params[] = (int)$month;
}

/* filter search */
if($search){
    $sql .= " AND am.activity_name LIKE ? ";
    $types .= "s";
    $params[] = "%$search%";
}

$sql .= " GROUP BY am.id ORDER BY e.name, t.name, am.activity_name";

/* prepare */
$stmt = mysqli_prepare($conn,$sql);
if($params){
    $refs = [];
    $refs[] = $types;
    foreach($params as $k=>$v){
        $refs[] = &$params[$k];
    }
    call_user_func_array([$stmt,'bind_param'],$refs);
}
mysqli_stmt_execute($stmt);
$res  = mysqli_stmt_get_result($stmt);
$data = mysqli_fetch_all($res,MYSQLI_ASSOC);

/* helper bulan */
$bulan = ["","Januari","Februari","Maret","April","Mei","Juni","Juli",
          "Agustus","September","Oktober","November","Desember"];
?>
<!doctype html>
<html lang="id">
<head>
<meta char
