<?php
session_start();
include "header.php";

/* ================= LOGOUT HANDLE ================= */
if (isset($_GET['page']) && $_GET['page'] === 'logout') {
    require 'logout.php';
    exit;
}

/* ================= CEK LOGIN ================= */
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

/* ================= PAGE & ROLE ================= */
$page = strtolower($_GET['page'] ?? 'dashboard');
$role = $_SESSION['role'] ?? 'Guest';

/* ================= DAFTAR PAGE ================= */
$pages = [
    "dashboard" => ["file" => "dashboard.php", "role" => ["Admin","Pegawai","Kepala Kantor","Users"]],
    "admintim" => ["file" => "admintim.php", "role" => ["Admin"]],
    "master_tim" => ["file" => "master_tim.php", "role" => ["Admin"]],
    "master_pegawai" => ["file" => "master_pegawai.php", "role" => ["Admin"]],
    "master_kegiatan" => ["file" => "master_kegiatan.php", "role" => ["Admin"]],
    "master_sub_kegiatan" => ["file" => "master_sub_kegiatan.php", "role" => ["Admin"]],
    "inputharian" => ["file" => "inputharian.php", "role" => ["Pegawai"]],
    "targetkegiatan" => ["file" => "targetkegiatan.php", "role" => ["Admin","Kepala Kantor"]],
    "totaltarget" => ["file" => "totaltarget.php", "role" => ["Admin","Kepala Kantor"]],
    "rekapkegiatan" => ["file" => "rekapkegiatan.php", "role" => ["Admin","Pegawai"]],
    "users" => ["file" => "users.php", "role" => ["Kepala Kantor"]],
];

/* ================= VALIDASI PAGE ================= */
if (!isset($pages[$page])) {
    $page = 'dashboard';
}

/* ================= VALIDASI ROLE ================= */
if (!in_array($role, $pages[$page]['role'])) {
    http_response_code(403);
    die("<h3 style='color:red;text-align:center;margin-top:40px'>⛔ Akses ditolak</h3>");
}

/* ================= HEADER / NAV ================= */
include "navigasi.php";

/* ================= PAGE CONTENT ================= */
include $pages[$page]['file'];

/* ================= FOOTER ================= */
include "footer.php";
