<?php
require_once 'config.php';

/* ================= HANDLER ================= */
if($_SERVER['REQUEST_METHOD'] === 'POST') {

  /* ===== ADD ===== */
  if (isset($_POST['action']) && $_POST['action'] === 'add') {
    $team_id = (int) $_POST['team_id'];
    $name = trim($_POST['name']);

    if ($team_id > 0 && $name !== '') {
      // CEK DOBEL (nama kegiatan + team)
      $chk = mysqli_prepare($conn,
        "SELECT id FROM master_kegiatan
         WHERE team_id = ? AND LOWER(nama_kegiatan) = LOWER(?) LIMIT 1");
      mysqli_stmt_bind_param($chk, "is", $team_id, $name);
      mysqli_stmt_execute($chk);
      mysqli_stmt_store_result($chk);
      $exists = mysqli_stmt_num_rows($chk) > 0;
      mysqli_stmt_close($chk);

      if ($exists) {
        echo "<script>
          localStorage.setItem('keg_error','duplicate');
          location='?page=master_kegiatan';
        </script>";
        exit;
      }

      $q = mysqli_prepare($conn,
        "INSERT INTO master_kegiatan(team_id,nama_kegiatan) VALUES(?,?)");
      mysqli_stmt_bind_param($q, "is", $team_id, $name);
      mysqli_stmt_execute($q);
      mysqli_stmt_close($q);
    }

    echo "<script>
      localStorage.setItem('notif','added');
      location='?page=master_kegiatan';
    </script>";
    exit;
  }

  /* ===== EDIT ===== */
  if (isset($_POST['action']) && $_POST['action'] === 'edit') {
    $id = (int) $_POST['id'];
    $team_id = (int) $_POST['team_id'];
    $name = trim($_POST['name']);

    if ($id > 0 && $team_id > 0 && $name !== '') {
      // CEK DOBEL (kecuali ID sendiri)
      $chk = mysqli_prepare($conn,
        "SELECT id FROM master_kegiatan
         WHERE team_id = ? AND LOWER(nama_kegiatan) = LOWER(?) AND id <> ? LIMIT 1");
      mysqli_stmt_bind_param($chk, "isi", $team_id, $name, $id);
      mysqli_stmt_execute($chk);
      mysqli_stmt_store_result($chk);
      $exists = mysqli_stmt_num_rows($chk) > 0;
      mysqli_stmt_close($chk);

      if ($exists) {
        echo "<script>
          localStorage.setItem('keg_error','duplicate_edit');
          location='?page=master_kegiatan';
        </script>";
        exit;
      }

      $q = mysqli_prepare($conn,
        "UPDATE master_kegiatan SET team_id = ?, nama_kegiatan = ? WHERE id = ?");
      mysqli_stmt_bind_param($q, "isi", $team_id, $name, $id);
      mysqli_stmt_execute($q);
      mysqli_stmt_close($q);
    }

    echo "<script>
      localStorage.setItem('notif','updated');
      location='?page=master_kegiatan';
    </script>";
    exit;
  }

  /* ===== DELETE (dilengkapi proteksi: cek penggunaan di activity_master) ===== */
  if (isset($_POST['action']) && $_POST['action'] === 'delete') {
    $id = (int) $_POST['id'];

    // Ambil nama kegiatan dulu
    $qname = mysqli_prepare($conn, "SELECT nama_kegiatan FROM master_kegiatan WHERE id = ?");
    mysqli_stmt_bind_param($qname, "i", $id);
    mysqli_stmt_execute($qname);
    $resName = mysqli_stmt_get_result($qname);
    $rowName = mysqli_fetch_assoc($resName);
    mysqli_stmt_close($qname);

    $nama_kegiatan = $rowName['nama_kegiatan'] ?? null;

    if ($nama_kegiatan !== null) {
      // Cek apakah nama_kegiatan ini dipakai di activity_master
      $chk = mysqli_prepare($conn,
        "SELECT 1 FROM activity_master WHERE LOWER(activity_name) = LOWER(?) LIMIT 1");
      mysqli_stmt_bind_param($chk, "s", $nama_kegiatan);
      mysqli_stmt_execute($chk);
      mysqli_stmt_store_result($chk);
      $used = mysqli_stmt_num_rows($chk) > 0;
      mysqli_stmt_close($chk);

      if ($used) {
        // Kembalikan ke UI menggunakan mekanisme localStorage yang sudah ada
        echo "<script>
          localStorage.setItem('keg_error','in_use');
          location='?page=master_kegiatan';
        </script>";
        exit;
      }
    }

    // Jika tidak dipakai, lakukan delete
    $q = mysqli_prepare($conn, "DELETE FROM master_kegiatan WHERE id = ?");
    mysqli_stmt_bind_param($q, "i", $id);
    mysqli_stmt_execute($q);
    mysqli_stmt_close($q);

    echo "<script>
      localStorage.setItem('notif','deleted');
      location='?page=master_kegiatan';
    </script>";
    exit;
  }

}

/* ================= DATA ================= */
$teams_arr = [];
$teams_q = mysqli_query($conn, "SELECT * FROM teams ORDER BY name");
while ($t = mysqli_fetch_assoc($teams_q)) $teams_arr[] = $t;

$res = mysqli_query($conn, "
SELECT mk.*, t.name AS team_name
FROM master_kegiatan mk
LEFT JOIN teams t ON t.id = mk.team_id
ORDER BY t.name, mk.nama_kegiatan
");
$total = mysqli_num_rows($res);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Master Kegiatan</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{background:#f4f6f9;font-size:12px}
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}.card-compact{border-radius:10px;box-shadow:0 3px 10px rgba(0,0,0,.05)}
.table {font-size: 13px}
.table th,.table td{padding:5px 8px;vertical-align:middle}
.table thead th{background:#0d6efd;color:#fff;border:0}
.btn-action{padding:4px 8px;font-size:11px}
.btn-action i{font-size:11px}
.form-control,.input-group-text{padding:4px 8px;font-size:12px}

#editBackdrop{position:fixed;inset:0;background:rgba(0,0,0,.35);z-index:1040;display:none}
#editBox{
  position:fixed;top:-240px;left:50%;transform:translateX(-50%);
  width:520px;max-width:95%;z-index:1060;opacity:0;
  transition:.35s cubic-bezier(.2,.9,.2,1)
}
#editBox.show{top:28px;opacity:1}
</style>
</head>

<body>
<div class="container mt-3">

<!-- TITLE -->
<div class="d-flex align-items-center mb-3">
  <i class="fa-solid fa-list-check fa-2x text-primary me-3"></i>
  <h3 class="mb-0 fw-semibold">Master Kegiatan</h3>
</div>

<!-- ADD -->
<form method="post" class="row g-1 mb-2 align-items-center">
<input type="hidden" name="action" value="add">

<div class="col-md-2">
  <div class="input-group input-group-sm">
    <span class="input-group-text">
      <i class="fa-solid fa-users"></i>
    </span>
    <select name="team_id" class="form-control" required>
      <option value="">Pilih Tim</option>
      <?php foreach($teams_arr as $t): ?>
      <option value="<?= (int)$t['id'] ?>"><?= htmlspecialchars($t['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</div>

<div class="col-md-3">
  <div class="input-group input-group-sm">
    <span class="input-group-text">
      <i class="fa-solid fa-list-check"></i>
    </span>
    <input name="name" class="form-control" placeholder="Nama Kegiatan" required>
  </div>
</div>

 <!-- TOMBOL TAMBAH -->
  <div class="col-auto d-flex align-items-center">
    <button type="submit" class="btn btn-primary btn-sm px-2">
      <i class="fa-solid fa-circle-plus me-1"></i> Tambah
    </button>
  </div>
</form>

<!-- TABLE -->
<table class="table table-bordered table-hover mb-0">
<thead class="text-center">
<tr>
<th width="50">No</th>
<th>Tim</th>
<th>Nama Kegiatan</th>
<th width="110">Aksi</th>
</tr>
</thead>
<tbody>
<?php if($total>0): $i=1; while($r=mysqli_fetch_assoc($res)): ?>
<tr>
<td class="text-center"><?= $i++ ?></td>
<td><?= htmlspecialchars($r['team_name']??'-') ?></td>
<td><?= htmlspecialchars($r['nama_kegiatan']) ?></td>
<td class="text-center">
<div class="d-inline-flex gap-1">

<button class="btn btn-outline-primary btn-action"
onclick="showEdit(<?= (int)$r['id'] ?>,<?= (int)$r['team_id'] ?>,'<?= addslashes($r['nama_kegiatan']) ?>')">
<i class="fa-solid fa-pen"></i>
</button>

<form method="post" class="delete-form m-0">
<input type="hidden" name="action" value="delete">
<input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
<button class="btn btn-outline-danger btn-action">
<i class="fa-solid fa-trash"></i>
</button>
</form>

</div>
</td>
</tr>
<?php endwhile; else: ?>
<tr><td colspan="4" class="text-center text-muted py-4">Belum ada kegiatan</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>

<!-- EDIT POPUP -->
<div id="editBackdrop"></div>

<div id="editBox" class="card card-compact p-3" style="display:none">
<h6 class="mb-2"><i class="fa-solid fa-pen-to-square text-success"></i> Edit Kegiatan</h6>

<form method="post" class="row g-2">
<input type="hidden" name="action" value="edit">
<input type="hidden" name="id" id="eid">

<div class="col-4">
<select name="team_id" id="eteam" class="form-control" required>
<option value="">Pilih Tim</option>
<?php foreach($teams_arr as $t): ?>
<option value="<?= (int)$t['id'] ?>"><?= htmlspecialchars($t['name']) ?></option>
<?php endforeach; ?>
</select>
</div>

<div class="col-5">
<input name="name" id="ename" class="form-control" required>
</div>

<div class="col-3 d-grid">
<button class="btn btn-success btn-sm">Simpan</button>
</div>
</form>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
const editBox=document.getElementById('editBox'),
      editBackdrop=document.getElementById('editBackdrop'),
      eid=document.getElementById('eid'),
      eteam=document.getElementById('eteam'),
      ename=document.getElementById('ename');

function showEdit(id,team,name){
  eid.value=id; eteam.value=team; ename.value=name;
  editBackdrop.style.display='block';
  editBox.style.display='block';
  setTimeout(()=>editBox.classList.add('show'),10);
}
function hideEdit(){
  editBox.classList.remove('show');
  setTimeout(()=>{editBox.style.display='none';editBackdrop.style.display='none'},350);
}
editBackdrop.onclick=hideEdit;

document.querySelectorAll('.delete-form').forEach(f=>{
  f.addEventListener('submit',e=>{
    e.preventDefault();
    Swal.fire({
      title:'Hapus kegiatan?',
      icon:'warning',showCancelButton:true,
      confirmButtonText:'Ya, hapus',cancelButtonText:'Batal',
      confirmButtonColor:'#d33'
    }).then(r=>{if(r.isConfirmed)f.submit()});
  });
});

// ===== POPUP =====
const err = localStorage.getItem('keg_error');
if(err){
  // Handle known error codes: 'duplicate', 'duplicate_edit', 'in_use'
  let txt = '';
  if(err === 'duplicate') txt = 'Nama kegiatan sudah ada pada tim tersebut.';
  else if(err === 'duplicate_edit') txt = 'Nama kegiatan sudah digunakan pada tim tersebut.';
  else if(err === 'in_use') txt = 'Kegiatan tidak bisa dihapus karena sudah dipakai pada data aktivitas.';
  else txt = 'Terjadi kesalahan.';

  Swal.fire({
    icon:'error',
    title:'Gagal',
    text: txt,
    confirmButtonText:'OK',
    confirmButtonColor:'#dc3545'
  });
  localStorage.removeItem('keg_error');
  localStorage.removeItem('notif');
}else{
  const n = localStorage.getItem('notif');
  if(n){
    Swal.fire({
      icon:'success',title:'Berhasil',
      text: n === 'added' ? 'Kegiatan ditambahkan' : n === 'updated' ? 'Kegiatan diperbarui' : 'Kegiatan dihapus',
      showConfirmButton:false,timer:1600
    });
    localStorage.removeItem('notif');
  }
}
</script>
</body>
</html>
