<?php
require_once 'config.php'; // pastikan $conn berada di config.php

/* ================= SMALL API: ensure sub exists (JSON) =================
   Usage: GET/POST ?action=ensure with parameter name
   Returns: JSON { success: true, id: <id>, created: true|false } or { success:false, message:... }
   Tujuan: dipanggil dari import Excel (admintim.php) agar sub_kegiatan otomatis dibuat bila belum ada.
*/
if(isset($_REQUEST['action']) && $_REQUEST['action'] === 'ensure'){
    header('Content-Type: application/json; charset=utf-8');
    $name = isset($_REQUEST['name']) ? trim($_REQUEST['name']) : '';
    if($name === ''){
        echo json_encode(['success'=>false,'message'=>'Nama kosong']); exit;
    }
    // cek duplicate case-insensitive
    $chk = mysqli_prepare($conn, "SELECT id FROM master_sub_kegiatan WHERE LOWER(nama_sub_kegiatan)=LOWER(?) LIMIT 1");
    mysqli_stmt_bind_param($chk, "s", $name);
    mysqli_stmt_execute($chk);
    $res = mysqli_stmt_get_result($chk);
    if($row = mysqli_fetch_assoc($res)){
        echo json_encode(['success'=>true,'id'=> (int)$row['id'], 'created'=>false]); exit;
    }
    mysqli_stmt_close($chk);

    $ins = mysqli_prepare($conn, "INSERT INTO master_sub_kegiatan(nama_sub_kegiatan) VALUES(?)");
    mysqli_stmt_bind_param($ins, "s", $name);
    $ok = mysqli_stmt_execute($ins);
    if($ok){
        $newId = mysqli_insert_id($conn);
        echo json_encode(['success'=>true,'id'=>$newId,'created'=>true]); exit;
    } else {
        echo json_encode(['success'=>false,'message'=>'Gagal memasukkan ke DB']); exit;
    }
}

/* ================= HANDLER (Add/Edit/Delete) ================= */
if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // ADD
    if(isset($_POST['action']) && $_POST['action'] === 'add'){
        $name = trim($_POST['name'] ?? '');
        if($name !== ''){
            // cek duplikat (case-insensitive)
            $chk = mysqli_prepare($conn, "SELECT id FROM master_sub_kegiatan WHERE LOWER(nama_sub_kegiatan)=LOWER(?) LIMIT 1");
            mysqli_stmt_bind_param($chk, "s", $name);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

            if($exists){
                echo "<script>
                    localStorage.setItem('notif_error','duplicate');
                    window.location='?page=master_sub_kegiatan';
                </script>";
                exit;
            }

            $q = mysqli_prepare($conn, "INSERT INTO master_sub_kegiatan(nama_sub_kegiatan) VALUES(?)");
            mysqli_stmt_bind_param($q, "s", $name);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }

        echo "<script>
            localStorage.setItem('subnotif','added');
            window.location='?page=master_sub_kegiatan';
        </script>";
        exit;
    }

    // EDIT
    if(isset($_POST['action']) && $_POST['action'] === 'edit'){
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        if($id > 0 && $name !== ''){
            $chk = mysqli_prepare($conn, "SELECT id FROM master_sub_kegiatan WHERE LOWER(nama_sub_kegiatan)=LOWER(?) AND id<>? LIMIT 1");
            mysqli_stmt_bind_param($chk, "si", $name, $id);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

            if($exists){
                echo "<script>
                    localStorage.setItem('notif_error','duplicate_edit');
                    window.location='?page=master_sub_kegiatan';
                </script>";
                exit;
            }

            $q = mysqli_prepare($conn, "UPDATE master_sub_kegiatan SET nama_sub_kegiatan=? WHERE id=?");
            mysqli_stmt_bind_param($q, "si", $name, $id);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }

        echo "<script>
            localStorage.setItem('subnotif','updated');
            window.location='?page=master_sub_kegiatan';
        </script>";
        exit;
    }

    // DELETE
    if(isset($_POST['action']) && $_POST['action'] === 'delete'){
        $id = (int)($_POST['id'] ?? 0);
        if($id > 0){
            $q = mysqli_prepare($conn, "DELETE FROM master_sub_kegiatan WHERE id=?");
            mysqli_stmt_bind_param($q,"i",$id);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }
        echo "<script>
            localStorage.setItem('subnotif','deleted');
            window.location='?page=master_sub_kegiatan';
        </script>";
        exit;
    }
}

/* ================= DATA ================= */
$res = mysqli_query($conn, "SELECT * FROM master_sub_kegiatan ORDER BY nama_sub_kegiatan");
$total = $res ? mysqli_num_rows($res) : 0;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Master Sub Kegiatan</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{ background:#f4f6f9; font-size:12px; }
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}.card-compact{ border-radius:10px; box-shadow:0 3px 10px rgba(0,0,0,0.05); background:#fff; }
h3{ margin-bottom:0.6rem; }

.table{ font-size:13px; }
.table th, .table td { padding:8px 10px !important; vertical-align:middle; }
.table thead th{ background:#0d6efd; color:#fff; border-color:transparent; }

.input-group-sm > .form-control, .input-group-sm > .form-select { padding:6px 8px; font-size:13px; }
.input-group-text{ padding:6px 8px; }
.btn-action{ padding:4px 8px; font-size:10px; border-radius:4px; }
.btn-action i{ font-size:10px; }

#editBackdrop{ position: fixed; inset: 0; background: rgba(0,0,0,0.32); z-index:1040; display:none; }
#editBox{ position: fixed; top: -260px; left:50%; transform:translateX(-50%); width:520px; max-width:95%; z-index:1060; opacity:0; transition: all .36s cubic-bezier(.2,.9,.2,1); border-radius:10px; background:#fff; box-shadow:0 10px 28px rgba(11,63,135,0.12); }
#editBox.show{ top:28px; opacity:1; }

@keyframes swal-pop { 0%{ transform:scale(.5); opacity:0 } 60%{ transform:scale(1.12); opacity:1 } 100%{ transform:scale(1); opacity:1 } }
.swal-success .swal2-success { animation: swal-pop 420ms cubic-bezier(.2,.9,.2,1); }

.form-compact .form-control { padding:6px 8px; font-size:13px; }

@media (max-width:576px){
  #editBox{ width:94%; left:50%; transform:translateX(-50%); }
}
</style>
</head>
<body>

<div class="container mt-3">

  <!-- TITLE -->
  <div class="d-flex align-items-center mb-2">
    <i class="fa-solid fa-list-check fa-2x text-primary me-2"></i>
    <h3 class="mb-0 fw-semibold">Master Sub Kegiatan</h3>
  </div>

    <!-- FORM TAMBAH -->
    <form id="addForm" method="post" class="row g-2 align-items-center">
      <input type="hidden" name="action" value="add">
      <div class="col-md-3">
        <div class="input-group input-group-sm form-compact">
          <span class="input-group-text"><i class="fa-solid fa-list"></i></span>
          <input name="name" class="form-control" placeholder="Nama Sub Kegiatan" required>
        </div>
      </div>
       <!-- TOMBOL TAMBAH (DIPERKECIL) -->
  <div class="col-auto d-flex align-items-center">
    <button type="submit" class="btn btn-primary btn-sm px-2">
      <i class="fa-solid fa-circle-plus me-1"></i> Tambah
    </button>
  </div>
    </form>

    <!-- TABLE -->
    <div class="table-responsive mt-2">
      <table class="table table-bordered table-hover mb-0">
        <thead class="text-center">
          <tr><th width="60">No</th><th>Nama Sub Kegiatan</th><th width="140">Aksi</th></tr>
        </thead>
        <tbody>
        <?php if($total==0): ?>
          <tr><td colspan="3" class="text-center text-muted py-4">Belum ada sub kegiatan</td></tr>
        <?php else: $i=1; while($r=mysqli_fetch_assoc($res)): ?>
          <tr>
            <td class="text-center"><?= $i++ ?></td>
            <td><?= htmlspecialchars($r['nama_sub_kegiatan']) ?></td>
            <td class="text-center">
              <div class="d-inline-flex gap-1 align-items-center">
                <button class="btn btn-outline-primary btn-action"
                  onclick='showEdit(<?= (int)$r['id'] ?>, <?= json_encode($r['nama_sub_kegiatan']) ?>)'>
                  <i class="fa-solid fa-pen"></i>
                </button>

                <form method="post" class="delete-form m-0" style="display:inline">
                  <input type="hidden" name="action" value="delete">
                  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                  <button type="submit" class="btn btn-outline-danger btn-action"><i class="fa-solid fa-trash"></i></button>
                </form>
              </div>
            </td>
          </tr>
        <?php endwhile; endif; ?>
        </tbody>
      </table>
    </div>
</div>

<!-- EDIT POPUP -->
<div id="editBackdrop"></div>
<div id="editBox" style="display:none;">
  <div class="p-3">
    <h6 class="mb-2"><i class="fa-solid fa-pen-to-square text-success me-2"></i> Edit Sub Kegiatan</h6>
    <form id="editForm" method="post" class="row g-2">
      <input type="hidden" name="action" value="edit">
      <input type="hidden" name="id" id="eid">
      <div class="col-md-9">
        <div class="input-group input-group-sm">
          <span class="input-group-text"><i class="fa-solid fa-list"></i></span>
          <input name="name" id="ename" class="form-control" required>
        </div>
      </div>
      <div class="col-md-3 d-grid">
        <button class="btn btn-success btn-sm" type="submit"><i class="fa-solid fa-floppy-disk me-1"></i> Simpan</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ===== Elements ===== */
const editBox = document.getElementById('editBox');
const editBackdrop = document.getElementById('editBackdrop');
const eid = document.getElementById('eid');
const ename = document.getElementById('ename');

/* show edit popup */
function showEdit(id, name){
  eid.value = id;
  ename.value = name;
  editBackdrop.style.display = 'block';
  editBox.style.display = 'block';
  setTimeout(()=> editBox.classList.add('show'), 10);
  setTimeout(()=> ename.focus(), 220);
}
function hideEdit(){
  editBox.classList.remove('show');
  setTimeout(()=> { editBox.style.display='none'; editBackdrop.style.display='none'; }, 360);
}
editBackdrop.addEventListener('click', hideEdit);
document.addEventListener('keydown', function(e){
  if(e.key === 'Escape' && editBox.style.display === 'block') hideEdit();
});

/* intercept add/edit form to set localStorage flags (so that after server redirect we show popup) */
const addForm = document.getElementById('addForm');
if(addForm){
  addForm.addEventListener('submit', function(){ try{ localStorage.setItem('subnotif','added'); }catch(e){} });
}
const editForm = document.getElementById('editForm');
if(editForm){
  editForm.addEventListener('submit', function(){ try{ localStorage.setItem('subnotif','updated'); }catch(e){} });
}

/* delete confirm + set flag */
document.addEventListener('DOMContentLoaded', function(){
  document.querySelectorAll('form.delete-form').forEach(function(form){
    form.addEventListener('submit', function(ev){
      ev.preventDefault();
      Swal.fire({
        title: 'Yakin ingin menghapus?',
        text: 'Sub kegiatan akan dihapus secara permanen.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#d33',
        reverseButtons: false,
        focusCancel: true
      }).then((result) => {
        if(result.isConfirmed){
          try{ localStorage.setItem('subnotif','deleted'); } catch(e){}
          form.submit();
        }
      });
    });
  });

  /* show success popup if flag exists */
  try {
    const f = localStorage.getItem('subnotif');
    if(f){
      let text = '';
      if(f==='added') text = 'Sub kegiatan berhasil ditambahkan.';
      else if(f==='updated') text = 'Sub kegiatan berhasil diperbarui.';
      else if(f==='deleted') text = 'Sub kegiatan berhasil dihapus.';

      Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: text,
        showConfirmButton: false,
        timer: 1600,
        timerProgressBar: true,
        customClass: { popup: 'swal-success' }
      });
      localStorage.removeItem('subnotif');
    }
  } catch(e){ console.error(e); }

  /* show duplicate error flags */
  try {
    const err = localStorage.getItem('notif_error');
    if(err){
      let text = '';
      if(err === 'duplicate') text = 'Nama sub kegiatan sudah terdaftar. Gunakan nama lain.';
      if(err === 'duplicate_edit') text = 'Nama sub kegiatan sudah digunakan oleh data lain.';
      if(text){
        Swal.fire({ icon:'error', title:'Gagal', text:text, confirmButtonColor:'#dc3545' });
      }
      localStorage.removeItem('notif_error');
    }
  } catch(e){ console.error(e); }
});
</script>

</body>
</html>
