<?php
// navigasi.php
if (!isset($pageTitle))  $pageTitle = '';
if (!isset($pageSubtitle)) $pageSubtitle = '';

function base_url() {
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $script = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');
    return $scheme . '://' . $host . $script . '/';
}
$base = base_url();
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Mikih.BPSMukomuko<?php echo htmlspecialchars($pageTitle); ?></title>
<link rel="icon" type="image/png" href="/monitoring_db/mikih.png">

<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@600;700&family=Poppins:wght@300;400;500;600&family=Roboto:wght@300;400;500&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
:root{
  --bg:#f5f7fb;
  --card:#ffffff;
  --muted-black:#1f2933;
  --teal:#2bb5a9;
  --gray:#9aa4ad;
  --accent:#1f7ed7;
  --sidebar-bg:#0f1720;
  --sidebar-text:#e6eef6;
  --logo-band:#052b44; /* warna berbeda di belakang logo */
  --logo-accent:#2bb5a9;
}

/* base */
*{box-sizing:border-box;margin:0;padding:0;font-family:'Poppins','Roboto','Montserrat',system-ui;}
html,body{height:100%;background:var(--bg);color:var(--muted-black);}

/* ===== SIDEBAR ===== */
.sidebar{
  position:fixed;
  left:0;top:0;
  width:220px;
  height:100vh;
  background:linear-gradient(180deg,var(--sidebar-bg) 0%, #003285 100%);
  padding:16px;
  display:flex;
  flex-direction:column;
  gap:14px;
  overflow:hidden;
  transition:width .25s ease;
  z-index: 800;
}

/* LOGO BAND (warna berbeda sebelum menu) */
.logo-band{
  display:flex;
  align-items:center;
  gap:12px;
  padding:12px;
}
.logo-box{
  width:56px;
  height:56px;
  min-width:56px;
  border-radius:6px;
  display:flex;
  align-items:center;
  justify-content:center;
  box-shadow: inset 0 0 0 1px rgba(255, 255, 255, 0.53);
  background: #ffffff;

}
.logo-box img{
  width:45px;
  height:45px;
  object-fit:contain;
  display:block;
}
.brand-text{
  color:rgba(255, 255, 255, 0.95);
  font-weight:600;
  font-size:13px;
  line-height:1;
}

/* NAV */
.nav{
  display:flex;
  flex-direction:column;
  gap:2px;

}
.section-title{
  font-size:11px;
  color:rgba(230,238,246,.5);
  margin:10px 0 4px;
}

.nav-item{
  display:flex;
  align-items:center;
  gap:10px;
  padding:8px 10px;
  border-radius:7px;
  font-size:12px;
  color:rgba(230,238,246,.9);
  text-decoration:none;
  white-space:nowrap;
  transition:.2s;
  border:none;
  outline:none;
}

.nav-item i{
  width:18px;
  text-align:center;
}

.nav-item:hover{
  background:rgba(255,255,255,.06);
  transform:translateX(2px);
}

.nav-item.active{
  background: rgba(0,60,255,.22);
  border:none;
  padding-left:10px;
  box-shadow:none;
}

.nav-item.logout{
  background:#ffffffcc;
  color:#0d6efd;
  font-weight:600;
}

.nav-item.logout:hover{
  background:red;
  color:#fff;
}

.sidebar{
  border:none;
  box-shadow:none;
}


/* ===== CONTENT ===== */
.content{
  margin-left:215px;
  padding:8px;
  min-height:100vh;
  transition:margin-left .25s ease;
}
.topbar{
  display:flex;
  align-items:center;
  margin-bottom:1px;
}
.page-title{font-size:18px;font-weight:600;}
.muted{font-size:12px;color:var(--gray);}
.card{
  background:#fff;
  border-radius:5px;
  padding:16px;
  box-shadow:0 6px 18px rgba(35,47,62,.06);
}

/* ===== COLLAPSED ===== */
body.sidebar-collapsed .sidebar{width:60px;padding:16px 8px;}
body.sidebar-collapsed .content{margin-left:60px;}
body.sidebar-collapsed .logo-band,
body.sidebar-collapsed .section-title,
body.sidebar-collapsed .nav-item span,
body.sidebar-collapsed .brand-text{display:none;}
body.sidebar-collapsed .nav-item{justify-content:center;}

/* ===== TRIANGULAR TOGGLE (di tengah vertikal) =====
   Kita buat seperti tab segitiga yang menempel di sisi kanan sidebar.
*/
.sidebar-toggle-tab{
  position: fixed;
  top: 50%;
  left: 220px;
  margin-top: -30px;
  width: 16px;
  height: 58px;
  cursor: pointer;
  z-index: 900;

  clip-path: polygon(
    0 0,
    90% 18%,
    95% 50%,
    90% 82%,
    0 100%
  );

  background: linear-gradient(180deg,var(--sidebar-bg) 0%, #003285 100%);
  display: flex;
  align-items: center;
  justify-content: center;

  border: none;
  outline: none;
  box-shadow: none;
  filter: none;

  transition: left .25s ease, background .2s ease;
}

.sidebar-toggle-tab::before{
  content:'';
  position:absolute;
  inset:0;
  background: inherit;
  clip-path: inherit;
  z-index:-1;
}

.sidebar-toggle-tab i{
  color:#fff;
  font-size:11px;
  pointer-events:none;
  transition: transform .25s ease;
}

body.sidebar-collapsed .sidebar-toggle-tab{
  left:60px;
}

body.sidebar-collapsed .sidebar-toggle-tab i{
  transform:rotate(180deg);
}

.sidebar-toggle-tab:hover{
  background: linear-gradient(180deg, rgb(8, 18, 63), rgba(6, 4, 117, 0.73));
}

/* MOBILE */
@media (max-width:700px){
  .sidebar{transform:translateX(-10px);}
  .sidebar-toggle-tab{left:200px;}
  body.sidebar-collapsed .sidebar-toggle-tab{left:48px;}
}

</style>

<script>
function toggleSidebar(){
  document.body.classList.toggle('sidebar-collapsed');
  // optional: simpan preferensi di localStorage supaya tetap teringat
  try {
    localStorage.setItem('sidebarCollapsed', document.body.classList.contains('sidebar-collapsed') ? '1' : '0');
  } catch(e){}
}

// restore state on load
document.addEventListener('DOMContentLoaded', function(){
  try{
    const v = localStorage.getItem('sidebarCollapsed');
    if(v==='1') document.body.classList.add('sidebar-collapsed');
  }catch(e){}
});
</script>
</head>

<body>

<!-- ===== SIDEBAR ===== -->
<aside class="sidebar" aria-label="Sidebar navigation">
  <!-- LOGO BAND (warna beda sebelum menu) -->
  <div class="logo-band" role="banner">
    <div class="logo-box">
      <img src="<?php echo htmlspecialchars($base.'mikih.PNG'); ?>" alt="Logo">
    </div>
    <div class="brand-text">
  MIKIH <br><small style="opacity:100;font-weight:100;font-size:10px">Monitoring Kinerja Individu Harian</small>
    </div>
  </div>

  <div class="nav" role="navigation">
    <div class="section-title">Menu</div>

<?php
$role = $_SESSION['role'] ?? 'Guest';

$menu = [
 'dashboard'=>[
    'icon'=>'fa-solid fa-gauge-high',
    'label'=>'Dashboard',
    'role'=>['Admin','Pegawai','Kepala Kantor','Users'] // ➕ Users
 ],
 'admintim'=>[
    'icon'=>'fa-regular fa-pen-to-square',
    'label'=>'Tambah Aktivitas',
    'role'=>['Admin']
 ],
 'master_tim'=>[
    'icon'=>'fa-solid fa-sitemap',
    'label'=>'Tim',
    'role'=>['Admin']
 ],
 'master_pegawai'=>[
    'icon'=>'fa-solid fa-id-badge',
    'label'=>'Pegawai',
    'role'=>['Admin']
 ],
 'master_kegiatan'=>[
    'icon'=>'fa-solid fa-list-check',
    'label'=>'Kegiatan',
    'role'=>['Admin']
 ],
 'master_sub_kegiatan'=>[
    'icon'=>'fa-solid fa-list',
    'label'=>'Sub Kegiatan',
    'role'=>['Admin']
 ],
 'inputharian'=>[
    'icon'=>'fa-solid fa-table-list',
    'label'=>'Input Kegiatan Harian',
    'role'=>['Pegawai']
 ],
 'targetkegiatan'=>[
    'icon'=>'fa-solid fa-bullseye',
    'label'=>'Target Kegiatan/Bulan',
    'role'=>['Kepala Kantor']
 ],
 'totaltarget'=>[
    'icon'=>'fa-solid fa-user-check',
    'label'=>'Total Target Tim',
    'role'=>['Kepala Kantor']
 ],
 'rekapkegiatan'=>[
    'icon'=>'fa-solid fa-users',
    'label'=>'Rekap Kegiatan',
    'role'=>['Admin','Pegawai']
 ],
  'users'=>[
    'icon'=>'fa-solid fa-user',
    'label'=>'Users',
    'role'=>['Kepala Kantor']
 ],
 'logout'=>[
    'icon'=>'fa-solid fa-right-from-bracket',
    'label'=>'Log Out',
    'role'=>['Admin','Pegawai','Kepala Kantor','Users'] // ➕ Users
 ],
 
];


$currentPage = strtolower($_GET['page'] ?? 'dashboard');

foreach($menu as $key=>$m){
 if(!in_array($role,$m['role'])) continue;
 $active = $key===$currentPage?'active':'';
 $logout = $key==='logout'?'logout':'';
 $url = $key==='logout' ? $base.'logout.php' : $base.'?page='.$key;

 echo '<a href="'.$url.'" class="nav-item '.$active.' '.$logout.'">
         <i class="'.$m['icon'].'"></i><span>'.$m['label'].'</span>
       </a>';
}
?>
  </div>

  <div style="flex:1"></div>
</aside>

<!-- ===== TRIANGULAR FLOATING TAB TOGGLE (DI TENGAH VERTIKAL) ===== -->
<button class="sidebar-toggle-tab" onclick="toggleSidebar()" aria-label="Toggle Sidebar">
<i class="fa-solid fa-chevron-left"></i>
</button>


<!-- ===== CONTENT ===== -->
<main class="content">
  <div class="topbar">
    <div>
      <h2 class="page-title"><?php echo htmlspecialchars($pageTitle); ?></h2>
      <div class="muted"><?php echo htmlspecialchars($pageSubtitle); ?></div>
    </div>
  </div>

  <div id="pageContent" class="card">
