<?php
// user-password.php
require_once 'config.php';
if (session_status() === PHP_SESSION_NONE) session_start();

if (empty($_SESSION['username'])) return;

// HANDLE POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['change_my_password'])) {
  header('Content-Type: application/json');

  $old = $_POST['old_password'] ?? '';
  $new = $_POST['new_password'] ?? '';

  if ($new === '' || strlen($new) < 6) {
    echo json_encode(['ok'=>false,'msg'=>'Password minimal 6 karakter']);
    exit;
  }

  $q = mysqli_prepare($conn,"SELECT password FROM users WHERE username=? LIMIT 1");
  mysqli_stmt_bind_param($q,"s",$_SESSION['username']);
  mysqli_stmt_execute($q);
  mysqli_stmt_bind_result($q,$dbpass);
  mysqli_stmt_fetch($q);
  mysqli_stmt_close($q);

  if ($dbpass !== $old) {
    echo json_encode(['ok'=>false,'msg'=>'Password lama salah']);
    exit;
  }

  $u = mysqli_prepare($conn,"UPDATE users SET password=? WHERE username=?");
  mysqli_stmt_bind_param($u,"ss",$new,$_SESSION['username']);
  mysqli_stmt_execute($u);
  mysqli_stmt_close($u);

  echo json_encode(['ok'=>true,'msg'=>'Password berhasil diubah']);
  exit;
}
?>

<!-- USER BADGE -->
<span id="mePwdBtn" class="user-badge" style="cursor:pointer">
  <i class="fa fa-user"></i>
  <em><?= htmlspecialchars($_SESSION['username']) ?></em>
</span>

<!-- MODAL -->
<div id="mePwdModal" style="display:none">
  <div style="position:fixed;inset:0;background:rgba(0,0,0,.35)"></div>
  <div style="position:fixed;top:50%;left:50%;transform:translate(-50%,-50%);
              background:#fff;padding:14px;border-radius:8px;width:260px">
    <h6>Ubah Password</h6>

    <form id="mePwdForm">
      <input type="password" name="old_password" class="form-control mb-2" placeholder="Password lama" required>
      <input type="password" name="new_password" class="form-control mb-2" placeholder="Password baru" required>
      <input type="hidden" name="change_my_password" value="1">
      <button class="btn btn-primary btn-sm w-100">Simpan</button>
      <small id="mePwdMsg"></small>
    </form>
  </div>
</div>

<script>
const btn = document.getElementById('mePwdBtn');
const modal = document.getElementById('mePwdModal');
const form = document.getElementById('mePwdForm');
const msg = document.getElementById('mePwdMsg');

btn.onclick = () => modal.style.display='block';
modal.onclick = e => { if(e.target === modal.children[0]) modal.style.display='none'; }

form.onsubmit = async e => {
  e.preventDefault();
  msg.textContent='Menyimpan...';
  const r = await fetch('',{method:'POST',body:new FormData(form)});
  const j = await r.json();
  msg.textContent = j.msg;
  if(j.ok) setTimeout(()=>modal.style.display='none',1000);
};
</script>
