<?php
// users.php
require_once 'config.php'; // pastikan $conn ada di sini
if (session_status() === PHP_SESSION_NONE) session_start();

/* ================= ROLE CHECK ================= */
if (($_SESSION['role'] ?? '') !== 'Kepala Kantor') {
    http_response_code(403);
    die("<h3 style='color:red;text-align:center;margin-top:40px'>
         ⛔ Akses ditolak — hanya Kepala Kantor
         </h3>");
}

/* ================= HANDLER (Add/Edit/Delete) ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    function clean($v){ return trim($v); }

    // ADD
    if (isset($_POST['action']) && $_POST['action'] === 'add') {
        $username = clean($_POST['username'] ?? '');
        $role = clean($_POST['role'] ?? '');
        $password = $_POST['password'] ?? '';

        if ($username !== '' && $role !== '' && $password !== '') {
            // cek duplicate username case-insensitive
            $chk = mysqli_prepare($conn, "SELECT id FROM users WHERE LOWER(username)=LOWER(?) LIMIT 1");
            mysqli_stmt_bind_param($chk, "s", $username);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

            if ($exists) {
                echo "<script>
                    localStorage.setItem('notif_error','duplicate_user');
                    window.location='?page=users';
                </script>";
                exit;
            }

            // *** SAVE PLAINTEXT PASSWORD (user requested) ***
            $q = mysqli_prepare($conn, "INSERT INTO users (username, password, role, created_at) VALUES (?, ?, ?, NOW())");
            mysqli_stmt_bind_param($q, "sss", $username, $password, $role);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }

        echo "<script>
            localStorage.setItem('usernotif','added');
            window.location='?page=users';
        </script>";
        exit;
    }

    // EDIT
    if (isset($_POST['action']) && $_POST['action'] === 'edit') {
        $id = (int)($_POST['id'] ?? 0);
        $username = clean($_POST['username'] ?? '');
        $role = clean($_POST['role'] ?? '');
        $password = $_POST['password'] ?? ''; // optional: if empty -> tidak diubah

        if ($id > 0 && $username !== '' && $role !== '') {
            // cek duplicate username pada id lain
            $chk = mysqli_prepare($conn, "SELECT id FROM users WHERE LOWER(username)=LOWER(?) AND id<>? LIMIT 1");
            mysqli_stmt_bind_param($chk, "si", $username, $id);
            mysqli_stmt_execute($chk);
            mysqli_stmt_store_result($chk);
            $exists = mysqli_stmt_num_rows($chk) > 0;
            mysqli_stmt_close($chk);

            if ($exists) {
                echo "<script>
                    localStorage.setItem('notif_error','duplicate_user_edit');
                    window.location='?page=users';
                </script>";
                exit;
            }

            if ($password !== '') {
                // update username+password+role (password saved plain)
                $q = mysqli_prepare($conn, "UPDATE users SET username=?, password=?, role=? WHERE id=?");
                mysqli_stmt_bind_param($q, "sssi", $username, $password, $role, $id);
            } else {
                // update username+role only
                $q = mysqli_prepare($conn, "UPDATE users SET username=?, role=? WHERE id=?");
                mysqli_stmt_bind_param($q, "ssi", $username, $role, $id);
            }
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }

        echo "<script>
            localStorage.setItem('usernotif','updated');
            window.location='?page=users';
        </script>";
        exit;
    }

    // DELETE
    if (isset($_POST['action']) && $_POST['action'] === 'delete') {
        $id = (int)($_POST['id'] ?? 0);
        if ($id > 0) {
            // prevent deleting yourself (if session has user_id)
            $selfId = (int)($_SESSION['user_id'] ?? 0);
            if ($selfId !== 0 && $selfId === $id) {
                echo "<script>
                    localStorage.setItem('notif_error','delete_self');
                    window.location='?page=users';
                </script>";
                exit;
            }

            $q = mysqli_prepare($conn, "DELETE FROM users WHERE id=?");
            mysqli_stmt_bind_param($q, "i", $id);
            mysqli_stmt_execute($q);
            mysqli_stmt_close($q);
        }

        echo "<script>
            localStorage.setItem('usernotif','deleted');
            window.location='?page=users';
        </script>";
        exit;
    }
}

/* ================= DATA ================= */
/* Menyesuaikan struktur tabel: id, username, password, role, created_at */
$res = mysqli_query($conn, "SELECT id, username, password, role, created_at FROM users ORDER BY username");
$total = $res ? mysqli_num_rows($res) : 0;

/* Role options */
$roles = ['Admin', 'Pegawai', 'Kepala Kantor', 'Users'];
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Manajemen Users</title>
<meta name="viewport" content="width=device-width,initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
body{ background:#f4f6f9; font-size:12px; }
.container{
  width:100%;
  max-width: min(3840px, 98vw);
  padding-left:12px;
  padding-right:12px;
}.card-compact{ border-radius:10px; box-shadow:0 3px 10px rgba(0,0,0,0.05); background:#fff; }
h3{ margin-bottom:0.6rem; }

.table{ font-size:13px; }
.table th, .table td { padding:8px 10px !important; vertical-align:middle; }
.table thead th{ background:#0d6efd; color:#fff; border-color:transparent; }

.input-group-sm > .form-control, .input-group-sm > .form-select { padding:6px 8px; font-size:13px; }
.input-group-text{ padding:6px 8px; }
.btn-action{ padding:4px 8px; font-size:10px; border-radius:4px; }
.btn-action i{ font-size:10px; }

.pwd-cell { display:flex; gap:6px; align-items:center; justify-content:center; }
.pwd-input { border:none; background:transparent; width:140px; text-align:center; font-family:inherit; font-size:13px; }
.pwd-input:focus{ outline:none; box-shadow:none; }

#editBackdrop{ position: fixed; inset: 0; background: rgba(0,0,0,0.32); z-index:1040; display:none; }
#editBox{ position: fixed; top: -260px; left:50%; transform:translateX(-50%); width:720px; max-width:95%; z-index:1060; opacity:0; transition: all .36s cubic-bezier(.2,.9,.2,1); border-radius:10px; background:#fff; box-shadow:0 10px 28px rgba(11,63,135,0.12); }
#editBox.show{ top:28px; opacity:1; }

@keyframes swal-pop { 0%{ transform:scale(.5); opacity:0 } 60%{ transform:scale(1.12); opacity:1 } 100%{ transform:scale(1); opacity:1 } }
.swal-success .swal2-success { animation: swal-pop 420ms cubic-bezier(.2,.9,.2,1); }

.form-compact .form-control { padding:6px 8px; font-size:13px; }

@media (max-width:576px){
  #editBox{ width:94%; left:50%; transform:translateX(-50%); }
}
</style>
</head>
<body>

<div class="container mt-3">

  <!-- TITLE -->
  <div class="d-flex align-items-center mb-2">
    <i class="fa-solid fa-user-gear fa-2x text-primary me-2"></i>
    <h3 class="mb-0 fw-semibold">Manajemen Users</h3>
  </div>

  <!-- FORM TAMBAH -->
  <form id="addForm" method="post" class="row g-2 align-items-center mb-2">
    <input type="hidden" name="action" value="add">
    <div class="col-md-3">
      <div class="input-group input-group-sm form-compact">
        <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
        <input name="username" class="form-control" placeholder="Username" required>
      </div>
    </div>

    <div class="col-md-3">
  <div class="input-group input-group-sm">
    <span class="input-group-text"><i class="fa-solid fa-shield-halved"></i></span>
    <select name="role" class="form-select" required>
      <option value="">Pilih Role</option>
      <?php foreach ($roles as $r): ?>
        <?php if ($r !== 'Users'): ?> 
          <option value="<?= htmlspecialchars($r) ?>">
            <?= htmlspecialchars($r) ?>
          </option>
        <?php endif; ?>
      <?php endforeach; ?>
    </select>
  </div>
</div>


    <div class="col-md-3">
      <div class="input-group input-group-sm form-compact">
        <span class="input-group-text"><i class="fa-solid fa-key"></i></span>
        <input name="password" type="text" class="form-control" placeholder="Password" required>
      </div>
    </div>

    <div class="col-auto d-flex align-items-center">
      <button type="submit" class="btn btn-primary btn-sm px-2">
        <i class="fa-solid fa-circle-plus me-1"></i> Tambah
      </button>
    </div>
  </form>

  <!-- TABLE -->
  <div class="table-responsive mt-2">
    <table class="table table-bordered table-hover mb-0">
      <thead class="text-center">
        <tr>
          <th width="60">No</th>
          <th>Username</th>
          <th width="220">Password</th>
          <th width="160">Role</th>
          <th width="180">Dibuat</th>
          <th width="120">Aksi</th>
        </tr>
      </thead>
      <tbody>
      <?php if ($total == 0): ?>
        <tr><td colspan="6" class="text-center text-muted py-4">Belum ada users</td></tr>
      <?php else: $i = 1; while($r = mysqli_fetch_assoc($res)): ?>
        <tr>
          <td class="text-center"><?= $i++ ?></td>
          <td><?= htmlspecialchars($r['username']) ?></td>
          <td class="text-center">
            <div class="pwd-cell">
              <input id="pwd-<?= (int)$r['id'] ?>" class="pwd-input" type="password" value="<?= htmlspecialchars($r['password']) ?>" readonly>
              <button type="button" class="btn btn-sm btn-light toggle-pwd" data-target="pwd-<?= (int)$r['id'] ?>" title="Tampilkan / Sembunyikan">
                <i class="fa-solid fa-eye"></i>
              </button>
            </div>
          </td>
          <td class="text-center"><?= htmlspecialchars($r['role']) ?></td>
          <td class="text-center"><?= htmlspecialchars($r['created_at']) ?></td>
          <td class="text-center">
            <div class="d-inline-flex gap-1 align-items-center">
              <button class="btn btn-outline-primary btn-action"
                      onclick='showEdit(<?= (int)$r['id'] ?>, <?= json_encode($r['username']) ?>, <?= json_encode($r['role']) ?>)'>
                <i class="fa-solid fa-pen"></i>
              </button>

              <form method="post" class="delete-form m-0" style="display:inline">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                <button type="submit" class="btn btn-outline-danger btn-action"><i class="fa-solid fa-trash"></i></button>
              </form>
            </div>
          </td>
        </tr>
      <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- EDIT POPUP -->
<div id="editBackdrop"></div>
<div id="editBox" style="display:none;">
  <div class="p-3">
    <h6 class="mb-2"><i class="fa-solid fa-pen-to-square text-success me-2"></i> Edit User</h6>
    <form id="editForm" method="post" class="row g-2">
      <input type="hidden" name="action" value="edit">
      <input type="hidden" name="id" id="eid">
      <div class="col-md-4">
        <div class="input-group input-group-sm">
          <span class="input-group-text"><i class="fa-solid fa-user"></i></span>
          <input name="username" id="eusername" class="form-control" required>
        </div>
      </div>

      <div class="col-md-3">
        <div class="input-group input-group-sm">
          <span class="input-group-text"><i class="fa-solid fa-shield-halved"></i></span>
          <select name="role" id="erole" class="form-select" required>
            <?php foreach($roles as $r): ?>
              <option value="<?php echo htmlspecialchars($r); ?>"><?php echo htmlspecialchars($r); ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>

      <div class="col-md-5">
        <div class="input-group input-group-sm">
          <span class="input-group-text"><i class="fa-solid fa-key"></i></span>
          <input name="password" id="epassword" type="text" class="form-control" placeholder="Masukkan password baru untuk mengganti (kosong = tidak berubah)">
        </div>
      </div>

      <div class="col-12 text-end">
        <button type="button" class="btn btn-secondary btn-sm me-2" onclick="hideEdit()">Batal</button>
        <button class="btn btn-success btn-sm" type="submit"><i class="fa-solid fa-floppy-disk me-1"></i> Simpan</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
/* ===== Elements ===== */
const editBox = document.getElementById('editBox');
const editBackdrop = document.getElementById('editBackdrop');
const eid = document.getElementById('eid');
const eusername = document.getElementById('eusername');
const erole = document.getElementById('erole');
const epassword = document.getElementById('epassword');

/* show edit popup */
function showEdit(id, username, role){
  eid.value = id;
  eusername.value = username;
  erole.value = role;
  epassword.value = '';
  editBackdrop.style.display = 'block';
  editBox.style.display = 'block';
  setTimeout(()=> editBox.classList.add('show'), 10);
  setTimeout(()=> eusername.focus(), 220);
}
function hideEdit(){
  editBox.classList.remove('show');
  setTimeout(()=> { editBox.style.display='none'; editBackdrop.style.display='none'; }, 360);
}
editBackdrop.addEventListener('click', hideEdit);
document.addEventListener('keydown', function(e){
  if(e.key === 'Escape' && editBox.style.display === 'block') hideEdit();
});

/* intercept add/edit form to set localStorage flags */
const addForm = document.getElementById('addForm');
if(addForm){
  addForm.addEventListener('submit', function(){ try{ localStorage.setItem('usernotif','added'); }catch(e){} });
}
const editForm = document.getElementById('editForm');
if(editForm){
  editForm.addEventListener('submit', function(){ try{ localStorage.setItem('usernotif','updated'); }catch(e){} });
}

/* password toggle (eye icon) */
document.addEventListener('click', function(e){
  const t = e.target.closest('.toggle-pwd');
  if(!t) return;
  const targetId = t.getAttribute('data-target');
  const input = document.getElementById(targetId);
  if(!input) return;
  if(input.type === 'password'){
    input.type = 'text';
    t.querySelector('i').classList.remove('fa-eye');
    t.querySelector('i').classList.add('fa-eye-slash');
  } else {
    input.type = 'password';
    t.querySelector('i').classList.remove('fa-eye-slash');
    t.querySelector('i').classList.add('fa-eye');
  }
});

/* delete confirm + set flag */
document.addEventListener('DOMContentLoaded', function(){
  document.querySelectorAll('form.delete-form').forEach(function(form){
    form.addEventListener('submit', function(ev){
      ev.preventDefault();
      Swal.fire({
        title: 'Yakin ingin menghapus user?',
        text: 'User akan dihapus secara permanen.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Ya, hapus',
        cancelButtonText: 'Batal',
        confirmButtonColor: '#d33',
        focusCancel: true
      }).then((result) => {
        if(result.isConfirmed){
          try{ localStorage.setItem('usernotif','deleted'); } catch(e){}
          form.submit();
        }
      });
    });
  });

  /* show success popup if flag exists */
  try {
    const f = localStorage.getItem('usernotif');
    if(f){
      let text = '';
      if(f==='added') text = 'User berhasil ditambahkan.';
      else if(f==='updated') text = 'User berhasil diperbarui.';
      else if(f==='deleted') text = 'User berhasil dihapus.';

      Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: text,
        showConfirmButton: false,
        timer: 1600,
        timerProgressBar: true,
        customClass: { popup: 'swal-success' }
      });
      localStorage.removeItem('usernotif');
    }
  } catch(e){ console.error(e); }

  /* show duplicate error flags */
  try {
    const err = localStorage.getItem('notif_error');
    if(err){
      let text = '';
      if(err === 'duplicate_user') text = 'Username sudah terdaftar. Gunakan username lain.';
      if(err === 'duplicate_user_edit') text = 'Username sudah digunakan oleh data lain.';
      if(err === 'delete_self') text = 'Anda tidak dapat menghapus user yang sedang login.';
      if(text){
        Swal.fire({ icon:'error', title:'Gagal', text:text, confirmButtonColor:'#dc3545' });
      }
      localStorage.removeItem('notif_error');
    }
  } catch(e){ console.error(e); }
});
</script>

</body>
</html>
